<?php

namespace App\Models;

use App\Enum\GrantApplicationType;
use App\Enum\GrantApplicationStatus;
use Illuminate\Database\Eloquent\Model;

class GrantApplication extends Model
{
    protected $guarded = [];

    protected function casts(): array
    {
        return [
            'status' => GrantApplicationStatus::class,
            'type' => GrantApplicationType::class
        ];
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function grantCategory()
    {
        return $this->belongsToMany(GrantCategory::class, 'grant_application_grant_category');
    }

    public function isPending()
    {
        return $this->status->value === GrantApplicationStatus::Pending->value;
    }

    public function isApproved()
    {
        return $this->status->value === GrantApplicationStatus::Approved->value;
    }

    public function isRejected()
    {
        return $this->status->value === GrantApplicationStatus::Rejected->value;
    }

    public function isWithdrawn()
    {
        return $this->status->value === GrantApplicationStatus::Withdrawn->value;
    }

    public function isTypeCompany()
    {
        return $this->type->value === GrantApplicationType::Company->value;
    }

    public function isTypeIndividual()
    {
        return $this->type->value === GrantApplicationType::Individual->value;
    }
}
