@extends('dashboard.master.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.master.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <x-dashboard.master.card>
                    <dl class="row">
                        <dt class="col-sm-3">Name:</dt>
                        <dd class="col-sm-9">{{ $admin->name }}</dd>

                        <dt class="col-sm-3">Email:</dt>
                        <dd class="col-sm-9">{{ $admin->email }}</dd>

                        <dt class="col-sm-3">Status:</dt>
                        <dd class="col-sm-9">
                            <span class="{{ $admin->status->badge() }}">{{ $admin->status->label() }}</span>
                        </dd>
                    </dl>
                    <x-dashboard.master.back-button href="{{ route('master.admin.index') }}" />
                </x-dashboard.master.card>
            </div>
            <!-- end col -->
        </div>
        <!-- end row -->

    </div>
@endsection
