@extends('dashboard.user.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.user.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="col-lg-10 mx-auto">
                    <div class="card border-0 shadow-lg rounded-4">

                        <!-- Header -->
                        <div
                            class="card-header bg-white border-bottom py-4 px-5 d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-1 fw-semibold">Transaction Record</h5>
                                <small class="text-muted">
                                    Reference ID: {{ $transaction->reference_id }}
                                </small>
                            </div>

                            <span class="{{ $transaction->status->badge() }} px-3 py-2">
                                {{ $transaction->status->label() }}
                            </span>
                        </div>

                        <div class="card-body p-5">

                            <!-- Amount Highlight -->
                            <div class="text-center mb-5">
                                @if ($transaction->isDirectionCredit())
                                    <h2 class="text-success fw-bold mb-1">
                                        +{{ currency($user->currency) }}{{ formatAmount($transaction->amount) }}
                                    </h2>
                                    <small class="text-muted">Credit Transaction</small>
                                @else
                                    <h2 class="text-danger fw-bold mb-1">
                                        -{{ currency($user->currency) }}{{ formatAmount($transaction->amount) }}
                                    </h2>
                                    <small class="text-muted">Debit Transaction</small>
                                @endif
                            </div>

                            <!-- General Details -->
                            <div class="mb-5">
                                <h6 class="text-uppercase text-muted fw-semibold mb-3">
                                    Transaction Information
                                </h6>

                                <div class="summary-row">
                                    <span>Transaction Type</span>
                                    <strong>{{ $transaction->type->label() }}</strong>
                                </div>

                                <div class="summary-row">
                                    <span>Transaction Date</span>
                                    <strong>{{ formatDateTime($transaction->transaction_at) }}</strong>
                                </div>

                                <div class="summary-row">
                                    <span>Available Balance After Transaction</span>
                                    <strong>
                                        {{ currency($user->currency) }}{{ formatAmount($transaction->current_balance) }}
                                    </strong>
                                </div>

                                <div class="summary-row">
                                    <span>Description</span>
                                    <strong>{{ $transaction->description ?? 'Not provided' }}</strong>
                                </div>
                            </div>

                            @if ($transaction->transfer)
                                <!-- Transfer Information -->
                                <div class="bg-light rounded-3 p-4 mb-5">
                                    <h6 class="text-uppercase text-muted fw-semibold mb-3">
                                        Transfer Details
                                    </h6>

                                    <div class="summary-row">
                                        <span>Beneficiary Name</span>
                                        <strong>{{ $transaction->transfer->recipient_name }}</strong>
                                    </div>

                                    <div class="summary-row">
                                        <span>Beneficiary Account</span>
                                        <strong>{{ $transaction->transfer->recipient_account_number }}</strong>
                                    </div>

                                    <div class="summary-row">
                                        <span>Beneficiary Bank</span>
                                        <strong>{{ $transaction->transfer->recipient_bank }}</strong>
                                    </div>

                                    @if ($transaction->transfer->recipient_swift_code)
                                        <div class="summary-row">
                                            <span>SWIFT Code</span>
                                            <strong>{{ $transaction->transfer->recipient_swift_code }}</strong>
                                        </div>
                                    @endif

                                    @if ($transaction->transfer->recipient_iban_code)
                                        <div class="summary-row">
                                            <span>IBAN</span>
                                            <strong>{{ $transaction->transfer->recipient_iban_code }}</strong>
                                        </div>
                                    @endif

                                    @if ($transaction->transfer->recipient_routing_number)
                                        <div class="summary-row">
                                            <span>Routing Number</span>
                                            <strong>{{ $transaction->transfer->recipient_routing_number }}</strong>
                                        </div>
                                    @endif

                                    <div class="summary-row">
                                        <span>Transfer Type</span>
                                        <strong>{{ $transaction->transfer->transfer_type->label() }}</strong>
                                    </div>

                                    <div class="summary-row">
                                        <span>Sender Account</span>
                                        <strong>{{ $transaction->transfer->sender_account_number }}</strong>
                                    </div>

                                    <div class="summary-row">
                                        <span>Sender Bank</span>
                                        <strong>{{ $transaction->transfer->sender_bank }}</strong>
                                    </div>
                                </div>
                            @endif

                        </div>
                    </div>

                    <div class="d-flex justify-content-end">
                        <a href="{{ route('transaction.receipt', [$transaction->uuid, $user->uuid]) }}"
                            class="btn btn-dark m-1">
                            <i class="bi bi-printer me-1"></i> Print Receipt
                        </a>
                        <a href="{{ route('user.transaction.index') }}" class="btn btn-primary m-1"> <i
                                class="ti ti-arrow-left me-1"></i> Back</a>
                    </div>

                </div>

                <style>
                    .summary-row {
                        display: flex;
                        justify-content: space-between;
                        padding: 12px 0;
                        border-bottom: 1px solid #f1f1f1;
                        font-size: 0.95rem;
                    }

                    .summary-row:last-child {
                        border-bottom: none;
                    }

                    .summary-row span {
                        color: #6c757d;
                    }

                    .summary-row strong {
                        font-weight: 600;
                    }
                </style>

            </div>
        </div>
    </div>
@endsection
