@extends('dashboard.user.layouts.app')
@section('content')
    <style>
        .summary-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #f1f1f1;
            font-size: 0.95rem;
        }

        .summary-row:last-child {
            border-bottom: none;
        }

        .summary-row span {
            color: #6c757d;
        }

        .summary-row strong {
            font-weight: 600;
        }
    </style>

    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.user.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-10 mx-auto">
                <div class="card border-0 shadow-lg rounded-4">
                    <div class="card-body p-5">

                        <!-- Header -->
                        <div class="mb-4">
                            <h4 class="fw-semibold mb-1">Review Transfer Details</h4>
                            <p class="text-muted mb-0">
                                Please carefully review the information below before authorizing this transaction.
                            </p>
                        </div>

                        <hr class="my-4">

                        <!-- Beneficiary Section -->
                        <div class="mb-4">
                            <h6 class="text-uppercase text-muted fw-semibold mb-3">
                                Beneficiary Information
                            </h6>

                            <div class="summary-row">
                                <span>Beneficiary Name</span>
                                <strong>{{ $transfer->recipient_name }}</strong>
                            </div>

                            <div class="summary-row">
                                <span>Account Number</span>
                                <strong>{{ $transfer->recipient_account_number }}</strong>
                            </div>

                            <div class="summary-row">
                                <span>Bank Name</span>
                                <strong>{{ $transfer->recipient_bank }}</strong>
                            </div>

                            @if ($transfer->recipient_swift_code)
                                <div class="summary-row">
                                    <span>SWIFT Code</span>
                                    <strong>{{ $transfer->recipient_swift_code }}</strong>
                                </div>
                            @endif

                            @if ($transfer->recipient_iban_code)
                                <div class="summary-row">
                                    <span>IBAN</span>
                                    <strong>{{ $transfer->recipient_iban_code }}</strong>
                                </div>
                            @endif

                            @if ($transfer->recipient_routing_number)
                                <div class="summary-row">
                                    <span>Routing Number</span>
                                    <strong>{{ $transfer->recipient_routing_number }}</strong>
                                </div>
                            @endif
                        </div>

                        <!-- Payment Section -->
                        <div class="bg-light rounded-3 p-4 mb-4">
                            <h6 class="text-uppercase text-muted fw-semibold mb-3">
                                Payment Details
                            </h6>

                            <div class="summary-row">
                                <span>Transfer Type</span>
                                <strong>{{ $transfer->transfer_type->fullLabel() }}</strong>
                            </div>

                            <div class="summary-row">
                                <span>Amount</span>
                                <strong class="fs-5 text-dark">
                                    {{ currency($user->currency) }}{{ formatAmount($transfer->amount) }}
                                </strong>
                            </div>

                            <div class="summary-row">
                                <span>Description</span>
                                <strong>{{ $transfer->description ?? '—' }}</strong>
                            </div>
                        </div>

                        <!-- Authorization Notice -->
                        <div class="alert alert-warning border-0 small">
                            By confirming this transfer, you authorize the debit of the above amount from your account.
                            This action may not be reversible once processed.
                        </div>

                        <!-- Action Buttons -->
                        <div class="d-flex justify-content-between mt-4">
                            <a href="{{ route('user.transfer.cancel', $transfer->uuid) }}"
                                onclick="return confirm('Are you sure you want to cancel this transfer?')"
                                class="btn btn-outline-secondary px-4">
                                Cancel
                            </a>

                            @if (!$user->shouldTransferFail())
                                @if ($transferNeedVerificationCode)
                                    <a href="{{ route('user.transfer.verify', [$transfer->uuid, $orderNo]) }}"
                                        class="btn btn-primary px-4">
                                        Confirm & Continue
                                    </a>
                                @else
                                    <a href="{{ route('user.transfer.complete', $transfer->uuid) }}"
                                        class="btn btn-primary px-4">
                                        Confirm Transfer
                                    </a>
                                @endif
                            @else
                                <a href="{{ route('user.transfer.fail', $transfer->uuid) }}" class="btn btn-primary px-4">
                                    Confirm Transfer
                                </a>
                            @endif
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
