@extends('dashboard.user.layouts.app')
@section('content')
    <style>
        .summary-row {
            display: flex;
            justify-content: space-between;
            padding: 12px 0;
            border-bottom: 1px solid #f1f1f1;
            font-size: 0.95rem;
        }

        .summary-row:last-child {
            border-bottom: none;
        }

        .summary-row span {
            color: #6c757d;
        }

        .summary-row strong {
            font-weight: 600;
        }
    </style>

    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.user.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-10 mx-auto">
                <div class="card border-0 shadow-lg rounded-4">

                    <!-- Header -->
                    <div
                        class="card-header bg-white border-bottom py-4 px-5 d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-1 fw-semibold">Transaction Details</h5>
                            <small class="text-muted">
                                Reference ID: {{ $transfer->reference_id }}
                            </small>
                        </div>

                        <span class="{{ $transfer->status->badge() }} px-3 py-2">
                            {{ $transfer->status->label() }}
                        </span>
                    </div>

                    <div class="card-body p-5">

                        <!-- Transaction Summary -->
                        <div class="mb-5">
                            <h6 class="text-uppercase text-muted fw-semibold mb-3">
                                Transaction Information
                            </h6>

                            <div class="summary-row">
                                <span>Transaction Date</span>
                                <strong>{{ formatDateTime($transfer->created_at) }}</strong>
                            </div>

                            <div class="summary-row">
                                <span>Transfer Type</span>
                                <strong>{{ $transfer->transfer_type->fullLabel() }}</strong>
                            </div>

                            <div class="summary-row">
                                <span>Currency</span>
                                <strong>{{ currency($transfer->user->currency, 'code') }}</strong>
                            </div>
                        </div>

                        <!-- Beneficiary Information -->
                        <div class="mb-5">
                            <h6 class="text-uppercase text-muted fw-semibold mb-3">
                                Beneficiary Information
                            </h6>

                            <div class="summary-row">
                                <span>Beneficiary Name</span>
                                <strong>{{ $transfer->recipient_name }}</strong>
                            </div>

                            <div class="summary-row">
                                <span>Account Number</span>
                                <strong>{{ $transfer->recipient_account_number }}</strong>
                            </div>

                            <div class="summary-row">
                                <span>Bank Name</span>
                                <strong>{{ $transfer->recipient_bank }}</strong>
                            </div>

                            <div class="summary-row">
                                <span>Account Type</span>
                                <strong>{{ $transfer->recipient_account_type }}</strong>
                            </div>

                            @if ($transfer->recipient_routing_number)
                                <div class="summary-row">
                                    <span>Routing Number</span>
                                    <strong>{{ $transfer->recipient_routing_number }}</strong>
                                </div>
                            @endif

                            @if ($transfer->recipient_swift_code)
                                <div class="summary-row">
                                    <span>SWIFT Code</span>
                                    <strong>{{ $transfer->recipient_swift_code }}</strong>
                                </div>
                            @endif

                            @if ($transfer->recipient_iban_code)
                                <div class="summary-row">
                                    <span>IBAN</span>
                                    <strong>{{ $transfer->recipient_iban_code }}</strong>
                                </div>
                            @endif
                        </div>

                        <!-- Amount Section -->
                        <div class="bg-light rounded-3 p-4 mb-5">
                            <h6 class="text-uppercase text-muted fw-semibold mb-3">
                                Amount Details
                            </h6>

                            <div class="summary-row">
                                <span>Amount Sent</span>
                                <strong class="fs-5">
                                    {{ currency($transfer->user->currency) }}{{ formatAmount($transfer->amount) }}
                                </strong>
                            </div>

                            {{-- Optional Fee Section --}}

                            {{-- <div class="summary-row">
                                <span>Transfer Fee</span>
                                <strong>{{ currency($transfer->user->currency) }}{{ formatAmount($transfer->fee) }}</strong>
                            </div>

                            <div class="summary-row">
                                <span>Total Deducted</span>
                                <strong class="fs-5">
                                    {{ currency($transfer->user->currency) }}{{ formatAmount($transfer->amount + $transfer->fee) }}
                                </strong>
                            </div> --}}

                        </div>

                        <!-- Description -->
                        <div class="mb-5">
                            <h6 class="text-uppercase text-muted fw-semibold mb-3">
                                Transaction Note
                            </h6>
                            <p class="text-muted mb-0">
                                {{ $transfer->description ?? 'No description provided.' }}
                            </p>
                        </div>

                        <!-- Footer Action -->
                        <div class="d-flex justify-content-between align-items-center pt-3 border-top">
                            <a href="{{ route('user.transfer.index') }}" class="btn btn-outline-secondary px-4">
                                Back to Transfers
                            </a>

                            {{-- Optional print --}}

                            {{-- <button onclick="window.print()" class="btn btn-dark px-4">
                                Print Receipt
                            </button> --}}

                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
