@extends('dashboard.user.layouts.app')
@section('content')
    <style>
        .success-icon-wrapper {
            width: 90px;
            height: 90px;
            background: rgba(25, 135, 84, 0.08);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .success-icon {
            width: 65px;
            height: 65px;
            background: linear-gradient(135deg, #198754, #157347);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 28px;
            box-shadow: 0 8px 20px rgba(25, 135, 84, 0.25);
        }
    </style>

    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.user.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="container py-5">
                    <div class="row justify-content-center">
                        <div class="col-lg-7 col-md-9">

                            <div class="card border-0 shadow-lg rounded-4 p-5 text-center">

                                <!-- Success Icon -->
                                <div class="mb-4">
                                    <div class="success-icon-wrapper mx-auto">
                                        <div class="success-icon">
                                            <i class="bi bi-check2 text-white"></i>
                                        </div>
                                    </div>
                                </div>

                                <!-- Success Heading -->
                                <h3 class="fw-semibold text-success mb-2">
                                    Transfer Completed Successfully
                                </h3>

                                <p class="text-muted mb-4">
                                    Your funds have been processed and credited to the beneficiary account.
                                    Please find the transaction summary below for your records.
                                </p>

                                <!-- Divider -->
                                <hr class="my-4">

                                <!-- Transaction Summary -->
                                <div class="table-responsive">
                                    <table class="table table-borderless align-middle text-start mb-0">
                                        <tbody>
                                            <tr>
                                                <th class="text-muted fw-medium">Transaction Reference</th>
                                                <td class="fw-semibold">{{ $transfer->reference_id }}</td>
                                            </tr>
                                            <tr>
                                                <th class="text-muted fw-medium">Amount</th>
                                                <td class="fw-semibold">
                                                    {{ currency($transfer->user->currency) }}{{ formatAmount($transfer->amount) }}
                                                </td>
                                            </tr>
                                            <tr>
                                                <th class="text-muted fw-medium">Beneficiary Name</th>
                                                <td>{{ $transfer->recipient_name }}</td>
                                            </tr>
                                            <tr>
                                                <th class="text-muted fw-medium">Bank</th>
                                                <td>{{ $transfer->recipient_bank }}</td>
                                            </tr>
                                            <tr>
                                                <th class="text-muted fw-medium">Account Number</th>
                                                <td>{{ $transfer->recipient_account_number }}</td>
                                            </tr>
                                            <tr>
                                                <th class="text-muted fw-medium">Transfer Type</th>
                                                <td class="text-capitalize">{{ $transfer->transfer_type->fullLabel() }}</td>
                                            </tr>
                                            <tr>
                                                <th class="text-muted fw-medium">Status</th>
                                                <td>
                                                    <span class="{{ $transfer->status->badge() }}">
                                                        {{ $transfer->status->label() }}
                                                    </span>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th class="text-muted fw-medium">Transaction Date</th>
                                                <td>{{ formatDateTime($transfer->created_at) }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                                <!-- Action Buttons -->
                                <div class="d-flex justify-content-center gap-3 mt-5">
                                    @if ($transfer->transfer_type->value == 'local')
                                        <a href="{{ route('user.transfer.local') }}"
                                            class="btn btn-outline-secondary px-4">
                                            <i class="bi bi-arrow-left me-1"></i> New Transfer
                                        </a>
                                    @else
                                        <a href="{{ route('user.transfer.international') }}"
                                            class="btn btn-outline-secondary px-4">
                                            <i class="bi bi-arrow-left me-1"></i> New Transfer
                                        </a>
                                    @endif
                                    <a href="{{ route('user.dashboard') }}" class="btn btn-primary px-4">
                                        <i class="bi bi-house-door me-1"></i> Go to Dashboard
                                    </a>
                                </div>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
