<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="UTF-8">
        <title>Transfer Verification Codes</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">

        <style>
            body {
                margin: 0;
                padding: 0;
                background-color: #f5f5f5;
                font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Arial, sans-serif;
                color: #1f2937;
            }

            .wrapper {
                width: 100%;
                padding: 40px 15px;
                background-color: #f5f5f5;
            }

            .container {
                max-width: 600px;
                margin: 0 auto;
                background: #ffffff;
                padding: 40px;
                border-radius: 6px;
                border: 1px solid #e5e7eb;
            }

            h2 {
                margin-top: 0;
                font-size: 18px;
                font-weight: 600;
            }

            p {
                font-size: 14px;
                line-height: 1.6;
                color: #4b5563;
            }

            .code-row {
                display: flex;
                justify-content: space-between;
                align-items: center;
                padding: 14px 0;
                border-bottom: 1px solid #f0f0f0;
                font-size: 14px;
            }

            .code-row:last-child {
                border-bottom: none;
            }

            .code-name {
                color: #6b7280;
            }

            .code-value {
                font-weight: 600;
                letter-spacing: 2px;
                background: #f3f4f6;
                padding: 8px 14px;
                border-radius: 4px;
                font-size: 15px;
            }

            .notice {
                margin-top: 25px;
                padding: 14px;
                background: #fafafa;
                border: 1px solid #e5e7eb;
                font-size: 13px;
                color: #6b7280;
            }

            .footer {
                margin-top: 30px;
                font-size: 12px;
                color: #9ca3af;
                border-top: 1px solid #eeeeee;
                padding-top: 15px;
            }
        </style>
    </head>

    <body>

        <div class="wrapper">
            <div class="container">

                <h2>Transfer Verification Required</h2>

                <p>
                    Hello {{ $user->fullName() }},
                </p>

                <p>
                    To complete your recent transfer request, please use the verification code(s) below.
                    Enter the code exactly as provided to proceed.
                </p>

                <!-- Codes -->
                @foreach ($transferCodes as $code)
                    <div class="code-row">
                        <div class="code-name">{{ $code->name }}</div>
                        <div class="code-value">{{ $code->code }}</div>
                    </div>
                @endforeach

                <div class="notice">
                    These codes are confidential and should not be shared with anyone.
                    Our support team will never ask for your verification codes.
                </div>

                <div class="footer">
                    This is an automated security notification. Please do not reply to this email.<br>
                    &copy; {{ date('Y') }} {{ config('app.name') }}. All rights reserved.
                </div>

            </div>
        </div>

    </body>

</html>
