<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="UTF-8">
        <title>{{ config('app.name') }} - Account Statement</title>
        <style>
            body {
                font-family: "Segoe UI", Arial, sans-serif;
                margin: 0;
                padding: 0;
                color: #333;
                font-size: 13px;
            }

            .header {
                background-color: #004aad;
                color: #fff;
                padding: 20px 30px;
                text-align: center;
            }

            .header h1 {
                margin: 0;
                font-size: 22px;
                letter-spacing: 1px;
            }

            .sub-header {
                background-color: #f8f9fc;
                padding: 15px 30px;
                border-bottom: 1px solid #e0e0e0;
            }

            .sub-header table {
                width: 100%;
                border-collapse: collapse;
            }

            .sub-header td {
                padding: 4px 0;
            }

            .statement-title {
                text-align: center;
                margin: 25px 0 15px;
                font-weight: bold;
                font-size: 18px;
                color: #004aad;
            }

            table.transactions {
                width: 90%;
                margin: 0 auto;
                border-collapse: collapse;
            }

            table.transactions th {
                background-color: #004aad;
                color: white;
                text-align: left;
                padding: 10px;
                font-size: 13px;
            }

            table.transactions td {
                padding: 10px;
                border-bottom: 1px solid #ddd;
            }

            tr:nth-child(even) {
                background-color: #f9f9f9;
            }

            .credit {
                color: #28a745;
                font-weight: bold;
            }

            .debit {
                color: #dc3545;
                font-weight: bold;
            }

            .summary {
                width: 90%;
                margin: 25px auto;
                border-top: 2px solid #004aad;
                padding-top: 10px;
            }

            .summary td {
                padding: 5px 0;
            }

            .footer {
                margin-top: 30px;
                text-align: center;
                font-size: 11px;
                color: #666;
                border-top: 1px solid #ddd;
                padding: 10px 0;
            }
        </style>
    </head>

    <body>

        <!-- Header -->
        <div class="header">
            <h1>{{ config('app.name') }}</h1>
            <p>Official Account Statement</p>
        </div>

        <!-- Account Info -->
        <div class="sub-header">
            <table>
                <tr>
                    <td><strong>Account Name:</strong> {{ $user->name }} {{ $user->middle_name }}
                        {{ $user->last_name }}</td>
                    <td><strong>Account Number:</strong> {{ $user->account_number }}</td>
                </tr>
                <tr>
                    <td><strong>Email:</strong> {{ $user->email }}</td>
                    <td><strong>Currency:</strong> {{ currency($user->currency, 'code') }}</td>
                </tr>
                <tr>
                    <td>
                        <strong>Period:</strong> {{ \Carbon\Carbon::parse($from)->format('M d, Y') }} -
                        {{ \Carbon\Carbon::parse($to)->format('M d, Y') }}
                    </td>

                    <td><strong>Date Generated:</strong> {{ now()->format('M d, Y h:i A') }}</td>
                </tr>
            </table>
        </div>

        <!-- Title -->
        <div class="statement-title">Transaction Summary</div>

        <!-- Transactions Table -->
        <table class="transactions">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Date</th>
                    <th>Description</th>
                    <th>Type</th>
                    <th>Amount ({{ currency($user->currency, 'code') }})</th>
                    <th>Balance ({{ currency($user->currency, 'code') }})</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($transactions as $index => $transaction)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ formatDateTime($transaction->transaction_at) }}</td>
                        <td>{{ $transaction->description ?? 'N/A' }}</td>
                        <td>{{ $transaction->type->label() }}</td>
                        <td class="{{ $transaction->isDirectionCredit() ? 'credit' : 'debit' }}">
                            {{ $transaction->isDirectionCredit() ? '+' : '-' }}{{ formatAmount($transaction->amount) }}
                        </td>
                        <td>{{ formatAmount($transaction->current_balance) }}</td>
                        <td>{{ ucfirst($transaction->status->label()) }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        <!-- Summary Section -->
        <table class="summary">
            <tr>
                <td><strong>Total Transactions:</strong></td>
                <td>{{ count($transactions) }}</td>
            </tr>
            <tr>
                <td><strong>Total Volume:</strong></td>
                <td>{{ formatAmount($totalAmount) }} {{ currency($user->currency, 'code') }}</td>
            </tr>
        </table>

        <!-- Footer -->
        <div class="footer">
            {{ config('app.name') }} | Confidential Statement | Generated on {{ now()->format('M d, Y h:i A') }}
        </div>

    </body>

</html>
