<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Frontend\HomeController;
use App\Http\Controllers\Frontend\PageController;
use App\Http\Controllers\Frontend\AboutController;
use App\Http\Controllers\Frontend\ContactController;
use App\Http\Controllers\Dashboard\TransactionReceiptController;

Route::get('/', HomeController::class)->name('home');


Route::get('/contact', [ContactController::class, 'index'])->name('contact');
Route::post('/contact', [ContactController::class, 'store']);

Route::get('/about', [PageController::class, 'about'])->name('about');
Route::get('/services', [PageController::class, 'services'])->name('services');

Route::middleware('auth')->get('/transaction/{transaction}/receipt/{user}', [TransactionReceiptController::class, 'index'])->name('transaction.receipt');

require __DIR__ . '/auth.php';
require __DIR__ . '/master.php';
require __DIR__ . '/user.php';
require __DIR__ . '/admin.php';
