<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="utf-8" />
        <title><?php echo e($title); ?> &mdash; <?php echo e(config('app.name')); ?></title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta content="<?php echo e(config('app.meta.keywords')); ?>" name="keywords">
        <meta content="<?php echo e(config('app.meta.description')); ?>" name="description">
        <meta property="og:title" content="<?php echo e(config('app.name')); ?> - <?php echo e(config('app.slogan')); ?>" />
        <meta property="og:type" content="website" />
        <meta property="og:url" content="<?php echo e(url()->current()); ?>" />
        <meta property="og:image" content="<?php echo e(asset(config('app.assets.og_image'))); ?>" />

        <!-- App favicon -->
        <link rel="shortcut icon" href="<?php echo e(asset(config('app.assets.favicon'))); ?>">

        <!-- Theme Config Js -->
        <script src="/dashboard/assets/js/config.js"></script>

        <!-- Vendor css -->
        <link href="/dashboard/assets/css/vendor.min.css" rel="stylesheet" type="text/css" />

        <!-- App css -->
        <link href="/dashboard/assets/css/app.min.css" rel="stylesheet" type="text/css" id="app-style" />

        <!-- Icons css -->
        <link href="/dashboard/assets/css/icons.min.css" rel="stylesheet" type="text/css" />

        <?php echo $__env->make('partials.google_translator', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <script src="/assets/js/sweet_alert2.js"></script>

        <!-- DataTables CSS -->
        <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">

        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    </head>

    <body>
        <!-- Begin page -->
        <div class="wrapper">

            <!-- Sidenav Menu Start -->
            <?php echo $__env->make('dashboard.master.layouts.side_nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <!-- Sidenav Menu End -->

            <!-- Topbar Start -->
            <?php echo $__env->make('dashboard.master.layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <!-- Topbar End -->

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->
            <div class="page-content">

                

                <?php echo $__env->make('partials.bootstrap_alert', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                <?php echo $__env->yieldContent('content'); ?>
                <!-- container -->

                <!-- Footer Start -->
                <?php echo $__env->make('dashboard.master.layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <!-- end Footer -->

            </div>
            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <!-- Vendor js -->
        <script src="/dashboard/assets/js/vendor.min.js"></script>

        <!-- App js -->
        <script src="/dashboard/assets/js/app.js"></script>

        <!-- jQuery -->
        <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

        <!-- DataTables JS -->
        <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
        <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

        <script>
            $(document).ready(function() {
                $('#myTable').DataTable({
                    // Optional settings
                    pageLength: 10,
                    lengthMenu: [
                        [5, 10, 25, -1],
                        [5, 10, 25, "All"]
                    ],
                    ordering: true,
                    responsive: true
                });
            });
        </script>

        <?php echo $__env->make('partials.live_chat', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.0\resources\views/dashboard/master/layouts/app.blade.php ENDPATH**/ ?>