

<dl class="row">
    
    <h5 class="mt-3 mb-3 text-primary fw-bold">Transaction Details</h5>

    <dt class="col-sm-3">Reference ID</dt>
    <dd class="col-sm-9"><?php echo e($transaction->reference_id); ?></dd>

    <dt class="col-sm-3">Type</dt>
    <dd class="col-sm-9"><?php echo e($transaction->type->label()); ?></dd>

    <dt class="col-sm-3">Amount</dt>
    <dd class="col-sm-9">
        <?php if($transaction->isDirectionCredit()): ?>
            <span class="text-success">
                +<?php echo e(currency($user->currency)); ?><?php echo e(formatAmount($transaction->amount)); ?>

            </span>
        <?php else: ?>
            <span class="text-danger">
                -<?php echo e(currency($user->currency)); ?><?php echo e(formatAmount($transaction->amount)); ?>

            </span>
        <?php endif; ?>
    </dd>

    <dt class="col-sm-3">Balance</dt>
    <dd class="col-sm-9"><?php echo e(currency($user->currency)); ?><?php echo e(formatAmount($transaction->current_balance)); ?></dd>

    <dt class="col-sm-3">Description</dt>
    <dd class="col-sm-9"><?php echo e($transaction->description ?? 'N/A'); ?></dd>

    <dt class="col-sm-3">Status</dt>
    <dd class="col-sm-9">
        <span class="<?php echo e($transaction->status->badge()); ?>">
            <?php echo e($transaction->status->label()); ?>

        </span>
    </dd>

    <dt class="col-sm-3">Date</dt>
    <dd class="col-sm-9"><?php echo e(formatDate($transaction->transaction_at)); ?></dd>

    
    <?php if($transaction->transfer): ?>
        <h5 class="mt-4 mb-3 text-primary fw-bold">Transfer Information</h5>

        <dt class="col-sm-3">Beneficiary Account</dt>
        <dd class="col-sm-9"><?php echo e($transaction->transfer->recipient_account_number); ?></dd>

        <dt class="col-sm-3">Beneficiary Name</dt>
        <dd class="col-sm-9"><?php echo e($transaction->transfer->recipient_name); ?></dd>

        <dt class="col-sm-3">Beneficiary Bank</dt>
        <dd class="col-sm-9"><?php echo e($transaction->transfer->recipient_bank); ?></dd>

        <?php if($transaction->transfer->recipient_swift_code): ?>
            <dt class="col-sm-3">Beneficiary SWIFT Code</dt>
            <dd class="col-sm-9"><?php echo e($transaction->transfer->recipient_swift_code); ?></dd>
        <?php endif; ?>

        <?php if($transaction->transfer->recipient_iban_code): ?>
            <dt class="col-sm-3">Beneficiary IBAN Code</dt>
            <dd class="col-sm-9"><?php echo e($transaction->transfer->recipient_iban_code); ?></dd>
        <?php endif; ?>

        <?php if($transaction->transfer->recipient_routing_number): ?>
            <dt class="col-sm-3">Beneficiary Routing Number</dt>
            <dd class="col-sm-9"><?php echo e($transaction->transfer->recipient_routing_number); ?></dd>
        <?php endif; ?>

        <dt class="col-sm-3">Transfer Type</dt>
        <dd class="col-sm-9"><?php echo e($transaction->transfer->transfer_type->label()); ?></dd>

        <dt class="col-sm-3">Sender</dt>
        <dd class="col-sm-9"><?php echo e($transaction->transfer->sender_account_number); ?></dd>

        <dt class="col-sm-3">Sender Bank</dt>
        <dd class="col-sm-9"><?php echo e($transaction->transfer->sender_bank); ?></dd>
    <?php endif; ?>
    
</dl>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.2\resources\views/dashboard/partials/transaction_details.blade.php ENDPATH**/ ?>