
<?php $__env->startSection('content'); ?>
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0"><?php echo e($title); ?></h4>
            </div>

            <div class="text-end">
                <?php if (isset($component)) { $__componentOriginalf249638ac7504c50bf0259c0cb71919d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf249638ac7504c50bf0259c0cb71919d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.user.breadcrumbs','data' => ['breadcrumbs' => $breadcrumbs]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.user.breadcrumbs'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['breadcrumbs' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($breadcrumbs)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf249638ac7504c50bf0259c0cb71919d)): ?>
<?php $attributes = $__attributesOriginalf249638ac7504c50bf0259c0cb71919d; ?>
<?php unset($__attributesOriginalf249638ac7504c50bf0259c0cb71919d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf249638ac7504c50bf0259c0cb71919d)): ?>
<?php $component = $__componentOriginalf249638ac7504c50bf0259c0cb71919d; ?>
<?php unset($__componentOriginalf249638ac7504c50bf0259c0cb71919d); ?>
<?php endif; ?>
            </div>
        </div>

        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <!-- Invoice Logo-->
                        <div class="d-flex align-items-start justify-content-between mb-4">
                            <div>

                            </div>
                            <div class="text-end">
                                <span class="<?php echo e($deposit->status->badge()); ?>"><?php echo e($deposit->status->label()); ?></span>
                                <h3 class="m-0 fw-bolder fs-20">Deposit: #<?php echo e($deposit->reference_id); ?></h3>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-6">
                                <div>
                                    <h5 class="fw-bold fs-14">Deposit Date:</h5>
                                    <h6 class="fs-14 text-muted"><?php echo e(formatDateTime($deposit->created_at)); ?></h6>
                                </div>
                            </div>

                            <div class="col-lg-6 text-end">
                                <?php if($deposit->isBitcoinMethod()): ?>
                                    <?php if($wallet->qr_code_path): ?>
                                        <div class="bg-light border rounded-3 p-3 mb-3 d-flex justify-content-center">
                                            <img src="<?php echo e(asset($wallet->qr_code_path)); ?>" alt="Payment QR Code"
                                                class="img-fluid rounded" style="max-width: 11rem;">
                                        </div>
                                    <?php else: ?>
                                        <img src="https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=<?php echo e($wallet->address); ?>?amount=<?php echo e($deposit->amount); ?>"
                                            alt="Payment QR Code" class="img-fluid rounded" style="max-width: 11rem;">
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <div class="mt-4">
                        <div class="table-responsive">
                            <table class="table text-center table-nowrap align-middle mb-0">
                                <thead>
                                    <tr class="bg-light bg-opacity-50">
                                        <th class="text-start border-0" scope="col">Deposit Details</th>
                                        <th class="text-end border-0" scope="col">Amount</th>
                                    </tr>
                                </thead>
                                <tbody id="products-list">
                                    <tr>
                                        <td class="text-start">
                                            <div class="d-flex align-items-center gap-2">
                                                <?php if($deposit->isBitcoinMethod()): ?>
                                                    <i class="fa-brands fa-bitcoin fs-22"></i>
                                                <?php elseif($deposit->isCreditCardMethod()): ?>
                                                    <i class="fa-brands fa-cc-visa fs-22"></i>
                                                <?php elseif($deposit->isPayPalMethod()): ?>
                                                    <i class="fa-brands fa-paypal fs-22"></i>
                                                <?php elseif($deposit->isBankTransferMethod()): ?>
                                                    <i class="fa-solid fa-bank fs-22"></i>
                                                <?php endif; ?>
                                                <div>
                                                    <span class="fw-medium"><?php echo e(ucfirst($deposit->method)); ?> Deposit</span>
                                                    <p class="text-muted mb-0">
                                                        <?php if($deposit->isBitcoinMethod()): ?>
                                                            Bitcoin Address: <?php echo e($wallet->address ?? 'N/A'); ?><br>
                                                            <?php if($deposit->proof): ?>
                                                                Proof: <a href="<?php echo e(asset($deposit->proof)); ?>"
                                                                    target="_blank">View</a>
                                                            <?php else: ?>
                                                                Proof: N/A
                                                            <?php endif; ?>
                                                        <?php elseif($deposit->isCreditCardMethod()): ?>
                                                            Card Number: **** **** ****
                                                            <?php echo e(substr($deposit->card_number ?? '', -4)); ?><br>
                                                            Expiry: <?php echo e($deposit->card_expiry_date ?? 'N/A'); ?>

                                                        <?php elseif($deposit->isPayPalMethod()): ?>
                                                            PayPal Email: <?php echo e($setting->paypal_email ?? 'N/A'); ?> <br>
                                                            <?php if($deposit->proof): ?>
                                                                Proof: <a href="<?php echo e(asset($deposit->proof)); ?>"
                                                                    target="_blank">View</a>
                                                            <?php else: ?>
                                                                Proof: N/A
                                                            <?php endif; ?>
                                                        <?php elseif($deposit->isBankTransferMethod()): ?>
                                                            Bank Name: <?php echo e($setting->bank_name ?? 'N/A'); ?><br>
                                                            Account Number: <?php echo e($setting->account_number ?? 'N/A'); ?><br>
                                                            Account Name: <?php echo e($setting->account_name ?? 'N/A'); ?> <br>
                                                            <?php if($setting->routing_number): ?>
                                                                Routing Number: <?php echo e($setting->routing_number ?? 'N/A'); ?>

                                                                <br>
                                                            <?php endif; ?>
                                                            <?php if($setting->bank_swift_code): ?>
                                                                Swift Code: <?php echo e($setting->bank_swift_code ?? 'N/A'); ?>

                                                                <br>
                                                            <?php endif; ?>
                                                            <?php if($setting->bank_iban): ?>
                                                                Iban Number: <?php echo e($setting->bank_iban ?? 'N/A'); ?> <br>
                                                            <?php endif; ?>
                                                            <?php if($deposit->proof): ?>
                                                                Proof: <a href="<?php echo e(asset($deposit->proof)); ?>"
                                                                    target="_blank">View</a>
                                                            <?php else: ?>
                                                                Proof: N/A
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </p>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="text-end">
                                            <?php echo e(currency($deposit->user->currency)); ?><?php echo e(formatAmount($deposit->amount)); ?>

                                        </td>
                                    </tr>
                                </tbody>
                            </table><!--end table-->
                        </div>
                    </div>

                    <div class="card-body">
                        <div class="bg-body rounded-2 mt-4">
                            <?php if($deposit->isBitcoinMethod() && $deposit->isPending()): ?>
                                <p class="mb-0"><span class="fs-12 fw-bold text-uppercase">Note:</span>
                                    Please ensure the Bitcoin payment is sent to the provided wallet address. Verification
                                    may take up to 1-3 hours after the transaction is confirmed on the blockchain.
                                </p>
                            <?php elseif($deposit->isCreditCardMethod() && $deposit->isPending()): ?>
                                <p class="mb-0"><span class="fs-12 fw-bold text-uppercase">Note:</span>
                                    The card payment is pending verification. Once confirmed, the deposit will be credited
                                    to your account within 1-2 business days.
                                </p>
                            <?php elseif($deposit->isPayPalMethod() && $deposit->isPending()): ?>
                                <p class="mb-0"><span class="fs-12 fw-bold text-uppercase">Note:</span>
                                    The PayPal payment is pending verification. Once confirmed, the deposit will be
                                    credited to your account within 1-2 business days.
                                </p>
                            <?php elseif($deposit->isBankTransferMethod() && $deposit->isPending()): ?>
                                <p class="mb-0"><span class="fs-12 fw-bold text-uppercase">Note:</span>
                                    The bank transfer is pending verification. Once confirmed, the deposit will be
                                    credited to your account within 1-2 business days.
                                </p>
                            <?php endif; ?>
                        </div>

                        <?php if($deposit->isPending()): ?>
                            <div class="mt-4">
                                <p class="mb-2 pb-2"><b>Thank you for your deposit!</b> We appreciate your trust in us and
                                    will
                                    process your request promptly.</p>
                            </div>
                        <?php endif; ?>

                        <div class="d-flex flex-wrap gap-2">
                            <a href="<?php echo e(route('user.deposit.history')); ?>" class="btn btn-primary"> <i
                                    class="ti ti-arrow-left me-1"></i> Back</a>
                        </div>
                    </div> <!-- end card-body-->
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.user.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.2\resources\views/dashboard/user/deposit/show.blade.php ENDPATH**/ ?>