<div class="table-responsive">
    <table id="myTable" class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Account Number</th>
                <th>Balance</th>
                <th>Status</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($loop->iteration); ?></td>
                    <td><a href="<?php echo e(route('admin.user.show', $user->uuid)); ?>"><?php echo e($user->name); ?>

                            <?php echo e($user->middle_name); ?> <?php echo e($user->last_name); ?></a>
                    </td>
                    <td><?php echo e($user->email); ?></td>
                    <td><?php echo e($user->phone); ?></td>
                    <td><?php echo e($user->account_number); ?></td>
                    <td><?php echo e(currency($user->currency)); ?><?php echo e(formatAmount($user->account_balance)); ?></td>
                    <td>
                        <span class="<?php echo e($user->status->badge()); ?>"> <?php echo e($user->status->label()); ?> </span>
                    </td>
                    <td>
                        <a href="<?php echo e(route('admin.user.show', $user->uuid)); ?>" class="btn btn-warning  btn-sm m-1">
                            <i class="ti ti-eye me-1">
                            </i>View </a>
                        <a href="<?php echo e(route('admin.user.edit', $user->uuid)); ?>" class="btn btn-primary  btn-sm m-1">
                            <i class="ti ti-edit me-1">
                            </i>Edit </a>
                        <form action="<?php echo e(route('admin.user.delete', $user->uuid)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger  btn-sm m-1"
                                onclick="return confirm('Are you sure you want to delete this account?')">
                                <i class="ti ti-trash me-1">
                                </i>Delete </button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.0\resources\views/components/dashboard/admin/users.blade.php ENDPATH**/ ?>