<!DOCTYPE html>
<html lang="en">

    <head>

        <title><?php echo e($title); ?> - <?php echo e(config('app.name')); ?></title>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <meta name="robots" content="index, follow">
        <meta name="apple-mobile-web-app-title" content="<?php echo e(config('app.name')); ?>">
        <meta name="application-name" content="<?php echo e(config('app.name')); ?>">
        <meta name="description" content="<?php echo e(config('app.meta.description')); ?>">
        <meta property="og:type" content="website" />
        <meta property="og:image" content="<?php echo e(asset(config('app.assets.og_image'))); ?>" />
        <link rel="shortcut icon" href="<?php echo e(asset(config('app.assets.favicon'))); ?>">
        <link href="temp/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <!-- Icons -->
        <link href="/frontend/temp/css/materialdesignicons.min.css" rel="stylesheet" type="text/css" />

        <link rel="stylesheet" href="/frontend/temp/css/line.css">
        <script src="/frontend/www.google.com/recaptcha/api.js" async defer></script>
        <!-- Main Css -->
        <link href="/frontend/temp/css/style.css" rel="stylesheet" type="text/css" />
        <link href="/frontend/temp/css/colors/blue.css" rel="stylesheet">

    </head>

    <body class="bg-black">
        <style>
            * {
                color: #fff
            }
        </style>
        <div class='text-center'>
            <div id="google_translate_element" class='text-dark'></div>

        </div>

        <?php echo $__env->make('partials.google_translator', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <section style="height: 100vh;" class="d-flex align-items-center justify-content-center">
            <div class="container">
                <div class="pb-3 row justify-content-center">

                    <div class="col-12 col-md-6 col-lg-6 col-sm-10 col-xl-6">
                        <a href="/"><img src="<?php echo e(asset(config('app.assets.logo'))); ?>"
                                class="mb-3 img-fluid auth__logo"></a>

                        <div id="google_translate_element" class='text-dark'></div>

                        <div class=" shadow card bg-black border login-page roundedd border-1 ">
                            <div class="card-body">
                                <h6 class='text-center text-white'>Please confirm you are not a Robot by verifying the
                                    auto-generated code below, this will enable you have access to Register. </h6>
                                <form method="POST" action="#" class="mt-4 login-form">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-group">

                                                <div class="position-relative">

                                                    <input type="text"
                                                        class=" form-control text-center text-white btn-primary"
                                                        name ="email" value="324936" readonly>
                                                </div>
                                            </div>
                                        </div>
                                        <!--end col-->

                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                <label style="color:#fff !important">Enter code<span
                                                        class="text-danger">*</span></label>
                                                <div class="position-relative">
                                                    <i data-feather="key" class="fea icon-sm icons"></i>
                                                    <input type="number" class="pl-5 form-control" name="code"
                                                        id="password" placeholder="Enter Code" tabindex="1" autofocus
                                                        required>
                                                </div>
                                            </div>
                                        </div>
                                        <!--end col-->

                                        <div class="col-lg-12">

                                            <!--end col-->

                                            <div class="mb-0 col-lg-12">
                                                <button class="btn btn-primary btn-block pad " type="submit">Verify
                                                    Code</button>
                                            </div>
                                            <!--end col-->

                                            <!--end col-->

                                            <!--end row-->
                                </form>
                            </div>
                        </div>
                        <!---->
                    </div>
                    <!--end col-->
                </div>
                <!--end row-->

            </div>
            <!--end container-->

        </section>
        <!--end section-->

        <script src="/frontend/temp/js/jquery-3.5.1.min.js"></script>
        <script src="/frontend/temp/js/bootstrap.bundle.min.js"></script>

        <!-- SLIDER -->
        <script src="/frontend/temp/js/owl.carousel.min.js"></script>
        <script src="/frontend/temp/js/owl.init.js"></script>
        <!-- Icons -->
        <script src="/frontend/temp/js/feather.min.js"></script>
        <script src="/frontend/temp/js/bundle.html"></script>

        <script src="/frontend/temp/js/app.js"></script>
        <script src="/frontend/temp/js/widget.js"></script>

        <!-- Livewire Scripts -->

        <script src="/frontend/livewire/livewire6b46.js?id=de3fca26689cb5a39af4" data-turbo-eval="false"
            data-turbolinks-eval="false"></script>
        <script data-turbo-eval="false" data-turbolinks-eval="false">
            if (window.livewire) {
                console.warn(
                    'Livewire: It looks like Livewire\'s @livewireScripts JavaScript assets have already been loaded. Make sure you aren\'t loading them twice.'
                )
            }

            window.livewire = new Livewire();
            window.livewire.devTools(true);
            window.Livewire = window.livewire;
            window.livewire_app_url = '';
            window.livewire_token = '3GLYtLNj0mU7CAjVDGsvmdGAF6oicfxkHyfnLTKA';

            /* Make sure Livewire loads first. */
            if (window.Alpine) {
                /* Defer showing the warning so it doesn't get buried under downstream errors. */
                document.addEventListener("DOMContentLoaded", function() {
                    setTimeout(function() {
                        console.warn(
                            "Livewire: It looks like AlpineJS has already been loaded. Make sure Livewire\'s scripts are loaded before Alpine.\\n\\n Reference docs for more info: http://laravel-livewire.com/docs/alpine-js"
                        )
                    })
                });
            }

            /* Make Alpine wait until Livewire is finished rendering to do its thing. */
            window.deferLoadingAlpine = function(callback) {
                window.addEventListener('livewire:load', function() {
                    callback();
                });
            };

            let started = false;

            window.addEventListener('alpine:initializing', function() {
                if (!started) {
                    window.livewire.start();

                    started = true;
                }
            });

            document.addEventListener("DOMContentLoaded", function() {
                if (!started) {
                    window.livewire.start();

                    started = true;
                }
            });
        </script>
        <script src="/frontend/cdn.jsdelivr.net/gh/livewire/turbolinks%40v0.1.4/dist/livewire-turbolinks.js"
            data-turbolinks-eval="false" data-turbo-eval="false"></script>
    </body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.0\resources\views/frontend/verify.blade.php ENDPATH**/ ?>