 <!-- Services Section -->
 <section
     class="relative py-16 lg:py-20 bg-gradient-to-br from-primary-600 via-primary-700 to-primary-800 dark:from-primary-800 dark:via-primary-900 dark:to-gray-900 overflow-hidden">
     <!-- Background Effects -->
     <div class="absolute inset-0">
         <div
             class="absolute top-0 left-0 w-full h-full bg-[radial-gradient(circle_at_30%_20%,rgba(255,255,255,0.1),transparent_50%)]">
         </div>
         <div
             class="absolute bottom-0 right-0 w-full h-full bg-[radial-gradient(circle_at_70%_80%,rgba(255,255,255,0.05),transparent_50%)]">
         </div>
         <!-- Floating Elements -->
         <div class="absolute top-20 left-20 w-32 h-32 bg-white/10 rounded-full blur-xl animate-float"></div>
         <div class="absolute bottom-20 right-20 w-48 h-48 bg-white/5 rounded-full blur-2xl animate-float-delayed">
         </div>
     </div>

     <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
         <div class="text-center mb-12 lg:mb-16">
             <div
                 class="inline-flex items-center px-4 py-2 bg-white/10 backdrop-blur-sm text-white/90 rounded-full text-sm font-semibold mb-4 border border-white/20">
                 <i class="fa-solid fa-concierge-bell mr-2 animate-pulse"></i>
                 Our Services
             </div>
             <h2 class="text-3xl sm:text-4xl lg:text-5xl font-bold text-white mb-4">
                 How Can We Help You Today?
             </h2>
             <p class="text-xl text-primary-100 max-w-2xl mx-auto">
                 Comprehensive banking solutions tailored to your needs
             </p>
         </div>

         <div class="grid sm:grid-cols-2 lg:grid-cols-3 gap-6 lg:gap-8">
             <!-- Deposit Accounts -->
             <div
                 class="group relative bg-white/5 backdrop-blur-sm rounded-2xl p-6 text-center transition-all duration-500 hover:bg-white/10 hover:-translate-y-2 border border-white/10 hover:border-white/20 hover:shadow-2xl hover:shadow-white/10">
                 <div
                     class="flex items-center justify-center w-20 h-20 bg-gradient-to-br from-white/20 to-white/10 rounded-2xl mb-6 mx-auto group-hover:scale-110 group-hover:rotate-6 transition-all duration-300 shadow-lg backdrop-blur-sm border border-white/20 group-hover:border-white/30">
                     <i class="fa-solid fa-university text-2xl text-white group-hover:text-primary-100"></i>
                 </div>
                 <h3 class="text-xl font-bold text-white mb-3 group-hover:text-primary-100 transition-colors">
                     Deposit Accounts</h3>
                 <p class="text-primary-100 leading-relaxed group-hover:text-white/90 transition-colors">Secure
                     your money with our high-yield savings and checking accounts designed for growth.</p>
                 <div class="mt-4 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                     <div class="w-12 h-0.5 bg-gradient-to-r from-transparent via-white/50 to-transparent mx-auto">
                     </div>
                 </div>
             </div>

             <!-- Credit Cards -->
             <div
                 class="group relative bg-white/5 backdrop-blur-sm rounded-2xl p-6 text-center transition-all duration-500 hover:bg-white/10 hover:-translate-y-2 border border-white/10 hover:border-white/20 hover:shadow-2xl hover:shadow-white/10">
                 <div
                     class="flex items-center justify-center w-20 h-20 bg-gradient-to-br from-white/20 to-white/10 rounded-2xl mb-6 mx-auto group-hover:scale-110 group-hover:rotate-6 transition-all duration-300 shadow-lg backdrop-blur-sm border border-white/20 group-hover:border-white/30">
                     <i class="fa-solid fa-credit-card text-2xl text-white group-hover:text-primary-100"></i>
                 </div>
                 <h3 class="text-xl font-bold text-white mb-3 group-hover:text-primary-100 transition-colors">
                     Credit Cards</h3>
                 <p class="text-primary-100 leading-relaxed group-hover:text-white/90 transition-colors">Find
                     the perfect credit card for your lifestyle and spending habits with competitive rates.</p>
                 <div class="mt-4 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                     <div class="w-12 h-0.5 bg-gradient-to-r from-transparent via-white/50 to-transparent mx-auto">
                     </div>
                 </div>
             </div>

             <!-- Loans -->
             <div
                 class="group relative bg-white/5 backdrop-blur-sm rounded-2xl p-6 text-center transition-all duration-500 hover:bg-white/10 hover:-translate-y-2 border border-white/10 hover:border-white/20 hover:shadow-2xl hover:shadow-white/10">
                 <div
                     class="flex items-center justify-center w-20 h-20 bg-gradient-to-br from-white/20 to-white/10 rounded-2xl mb-6 mx-auto group-hover:scale-110 group-hover:rotate-6 transition-all duration-300 shadow-lg backdrop-blur-sm border border-white/20 group-hover:border-white/30">
                     <i class="fa-solid fa-home text-2xl text-white group-hover:text-primary-100"></i>
                 </div>
                 <h3 class="text-xl font-bold text-white mb-3 group-hover:text-primary-100 transition-colors">
                     Loans</h3>
                 <p class="text-primary-100 leading-relaxed group-hover:text-white/90 transition-colors">Get
                     competitive rates on personal, auto, and home loans tailored to your financial goals.</p>
                 <div class="mt-4 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                     <div class="w-12 h-0.5 bg-gradient-to-r from-transparent via-white/50 to-transparent mx-auto">
                     </div>
                 </div>
             </div>

             <!-- Business Banking -->
             <div
                 class="group relative bg-white/5 backdrop-blur-sm rounded-2xl p-6 text-center transition-all duration-500 hover:bg-white/10 hover:-translate-y-2 border border-white/10 hover:border-white/20 hover:shadow-2xl hover:shadow-white/10">
                 <div
                     class="flex items-center justify-center w-20 h-20 bg-gradient-to-br from-white/20 to-white/10 rounded-2xl mb-6 mx-auto group-hover:scale-110 group-hover:rotate-6 transition-all duration-300 shadow-lg backdrop-blur-sm border border-white/20 group-hover:border-white/30">
                     <i class="fa-solid fa-briefcase text-2xl text-white group-hover:text-primary-100"></i>
                 </div>
                 <h3 class="text-xl font-bold text-white mb-3 group-hover:text-primary-100 transition-colors">
                     Business Banking</h3>
                 <p class="text-primary-100 leading-relaxed group-hover:text-white/90 transition-colors">
                     Comprehensive banking solutions designed to help your business thrive and grow.</p>
                 <div class="mt-4 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                     <div class="w-12 h-0.5 bg-gradient-to-r from-transparent via-white/50 to-transparent mx-auto">
                     </div>
                 </div>
             </div>

             <!-- Wealth & Retire -->
             <div
                 class="group relative bg-white/5 backdrop-blur-sm rounded-2xl p-6 text-center transition-all duration-500 hover:bg-white/10 hover:-translate-y-2 border border-white/10 hover:border-white/20 hover:shadow-2xl hover:shadow-white/10">
                 <div
                     class="flex items-center justify-center w-20 h-20 bg-gradient-to-br from-white/20 to-white/10 rounded-2xl mb-6 mx-auto group-hover:scale-110 group-hover:rotate-6 transition-all duration-300 shadow-lg backdrop-blur-sm border border-white/20 group-hover:border-white/30">
                     <i class="fa-solid fa-chart-pie text-2xl text-white group-hover:text-primary-100"></i>
                 </div>
                 <h3 class="text-xl font-bold text-white mb-3 group-hover:text-primary-100 transition-colors">
                     Wealth & Retire</h3>
                 <p class="text-primary-100 leading-relaxed group-hover:text-white/90 transition-colors">Plan
                     for your future with our expert investment and retirement planning services.</p>
                 <div class="mt-4 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                     <div class="w-12 h-0.5 bg-gradient-to-r from-transparent via-white/50 to-transparent mx-auto">
                     </div>
                 </div>
             </div>

             <!-- About <?php echo e(config('app.name')); ?> -->
             <div
                 class="group relative bg-white/5 backdrop-blur-sm rounded-2xl p-6 text-center transition-all duration-500 hover:bg-white/10 hover:-translate-y-2 border border-white/10 hover:border-white/20 hover:shadow-2xl hover:shadow-white/10">
                 <div
                     class="flex items-center justify-center w-20 h-20 bg-gradient-to-br from-white/20 to-white/10 rounded-2xl mb-6 mx-auto group-hover:scale-110 group-hover:rotate-6 transition-all duration-300 shadow-lg backdrop-blur-sm border border-white/20 group-hover:border-white/30">
                     <i class="fa-solid fa-info-circle text-2xl text-white group-hover:text-primary-100"></i>
                 </div>
                 <h3 class="text-xl font-bold text-white mb-3 group-hover:text-primary-100 transition-colors">
                     About <?php echo e(config('app.name')); ?></h3>
                 <p class="text-primary-100 leading-relaxed group-hover:text-white/90 transition-colors">Learn
                     more about our commitment to exceptional banking services and community support.</p>
                 <div class="mt-4 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                     <div class="w-12 h-0.5 bg-gradient-to-r from-transparent via-white/50 to-transparent mx-auto">
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </section>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.0\resources\views/frontend/layouts/partials/services.blade.php ENDPATH**/ ?>