<!-- Account Types Section -->
<section class="py-16 bg-white dark:bg-gray-900">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl lg:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                Personal Accounts
            </h2>
            <p class="text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
                Choose from our range of personal banking accounts designed for your lifestyle
            </p>
        </div>

        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Checking Account -->
            <div
                class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div class="w-16 h-16 bg-blue-100 dark:bg-blue-900/30 rounded-2xl flex items-center justify-center mb-6">
                    <i class="fa-solid fa-university text-2xl text-blue-600 dark:text-blue-400"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Checking Account</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Everyday banking made easy with no monthly fees and unlimited transactions.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>No monthly
                        maintenance fee</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Free online and
                        mobile banking</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Free debit card
                    </li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Overdraft
                        protection available</li>
                </ul>
                <a href="<?php echo e(route('register')); ?>"
                    class="inline-flex items-center text-blue-600 dark:text-blue-400 font-semibold hover:text-blue-700 dark:hover:text-blue-300 transition-colors">
                    Open Account <i class="fa-solid fa-arrow-right ml-2"></i>
                </a>
            </div>

            <!-- Savings Account -->
            <div
                class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div
                    class="w-16 h-16 bg-green-100 dark:bg-green-900/30 rounded-2xl flex items-center justify-center mb-6">
                    <i class="fa-solid fa-piggy-bank text-2xl text-green-600 dark:text-green-400"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">High-Yield Savings</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Grow your money with competitive interest rates and flexible access.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>2.50% APY
                        interest rate</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>No minimum
                        balance</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>FDIC insured up
                        to $250K</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Mobile banking
                        access</li>
                </ul>
                <a href="<?php echo e(route('register')); ?>"
                    class="inline-flex items-center text-green-600 dark:text-green-400 font-semibold hover:text-green-700 dark:hover:text-green-300 transition-colors">
                    Open Account <i class="fa-solid fa-arrow-right ml-2"></i>
                </a>
            </div>

            <!-- Money Market -->
            <div
                class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div
                    class="w-16 h-16 bg-purple-100 dark:bg-purple-900/30 rounded-2xl flex items-center justify-center mb-6">
                    <i class="fa-solid fa-chart-line text-2xl text-purple-600 dark:text-purple-400"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Money Market</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Higher interest rates with check-writing privileges and debit card access.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>3.25% APY
                        interest rate</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>$2,500 minimum
                        balance</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Limited check
                        writing</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Debit card
                        included</li>
                </ul>
                <a href="<?php echo e(route('register')); ?>"
                    class="inline-flex items-center text-purple-600 dark:text-purple-400 font-semibold hover:text-purple-700 dark:hover:text-purple-300 transition-colors">
                    Open Account <i class="fa-solid fa-arrow-right ml-2"></i>
                </a>
            </div>

            <!-- CD Account -->
            <div
                class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div
                    class="w-16 h-16 bg-orange-100 dark:bg-orange-900/30 rounded-2xl flex items-center justify-center mb-6">
                    <i class="fa-solid fa-certificate text-2xl text-orange-600 dark:text-orange-400"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Certificate of Deposit</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Lock in guaranteed returns with our competitive CD rates and terms.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Up to 4.50% APY
                    </li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Terms from 3
                        months to 5 years</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>$1,000 minimum
                        deposit</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Guaranteed rate
                        of return</li>
                </ul>
                <a href="<?php echo e(route('register')); ?>"
                    class="inline-flex items-center text-orange-600 dark:text-orange-400 font-semibold hover:text-orange-700 dark:hover:text-orange-300 transition-colors">
                    Open Account <i class="fa-solid fa-arrow-right ml-2"></i>
                </a>
            </div>

            <!-- IRA Account -->
            <div
                class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div
                    class="w-16 h-16 bg-teal-100 dark:bg-teal-900/30 rounded-2xl flex items-center justify-center mb-6">
                    <i class="fa-solid fa-umbrella text-2xl text-teal-600 dark:text-teal-400"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">IRA Accounts</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Plan for retirement with traditional and Roth IRA options.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Traditional and
                        Roth options</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Tax advantages
                    </li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Investment
                        options available</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Retirement
                        planning tools</li>
                </ul>
                <a href="<?php echo e(route('register')); ?>"
                    class="inline-flex items-center text-teal-600 dark:text-teal-400 font-semibold hover:text-teal-700 dark:hover:text-teal-300 transition-colors">
                    Open Account <i class="fa-solid fa-arrow-right ml-2"></i>
                </a>
            </div>

            <!-- Youth Account -->
            <div
                class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div
                    class="w-16 h-16 bg-pink-100 dark:bg-pink-900/30 rounded-2xl flex items-center justify-center mb-6">
                    <i class="fa-solid fa-child text-2xl text-pink-600 dark:text-pink-400"></i>
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Youth Savings</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Help young savers build good financial habits with our youth accounts.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Ages 13-17
                        eligible</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>No monthly fees
                    </li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Financial
                        education resources</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Parent/guardian
                        oversight</li>
                </ul>
                <a href="<?php echo e(route('register')); ?>"
                    class="inline-flex items-center text-pink-600 dark:text-pink-400 font-semibold hover:text-pink-700 dark:hover:text-pink-300 transition-colors">
                    Open Account <i class="fa-solid fa-arrow-right ml-2"></i>
                </a>
            </div>
        </div>
    </div>
</section>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.0\resources\views/frontend/sections/services/personal_banking/account_types.blade.php ENDPATH**/ ?>