<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="UTF-8">
        <title><?php echo e(config('app.name')); ?> - Account Statement</title>
        <style>
            body {
                font-family: "Segoe UI", Arial, sans-serif;
                margin: 0;
                padding: 0;
                color: #333;
                font-size: 13px;
            }

            .header {
                background-color: #004aad;
                color: #fff;
                padding: 20px 30px;
                text-align: center;
            }

            .header h1 {
                margin: 0;
                font-size: 22px;
                letter-spacing: 1px;
            }

            .sub-header {
                background-color: #f8f9fc;
                padding: 15px 30px;
                border-bottom: 1px solid #e0e0e0;
            }

            .sub-header table {
                width: 100%;
                border-collapse: collapse;
            }

            .sub-header td {
                padding: 4px 0;
            }

            .statement-title {
                text-align: center;
                margin: 25px 0 15px;
                font-weight: bold;
                font-size: 18px;
                color: #004aad;
            }

            table.transactions {
                width: 90%;
                margin: 0 auto;
                border-collapse: collapse;
            }

            table.transactions th {
                background-color: #004aad;
                color: white;
                text-align: left;
                padding: 10px;
                font-size: 13px;
            }

            table.transactions td {
                padding: 10px;
                border-bottom: 1px solid #ddd;
            }

            tr:nth-child(even) {
                background-color: #f9f9f9;
            }

            .credit {
                color: #28a745;
                font-weight: bold;
            }

            .debit {
                color: #dc3545;
                font-weight: bold;
            }

            .summary {
                width: 90%;
                margin: 25px auto;
                border-top: 2px solid #004aad;
                padding-top: 10px;
            }

            .summary td {
                padding: 5px 0;
            }

            .footer {
                margin-top: 30px;
                text-align: center;
                font-size: 11px;
                color: #666;
                border-top: 1px solid #ddd;
                padding: 10px 0;
            }
        </style>
    </head>

    <body>

        <!-- Header -->
        <div class="header">
            <h1><?php echo e(config('app.name')); ?></h1>
            <p>Official Account Statement</p>
        </div>

        <!-- Account Info -->
        <div class="sub-header">
            <table>
                <tr>
                    <td><strong>Account Name:</strong> <?php echo e($user->name); ?> <?php echo e($user->middle_name); ?>

                        <?php echo e($user->last_name); ?></td>
                    <td><strong>Account Number:</strong> <?php echo e($user->account_number); ?></td>
                </tr>
                <tr>
                    <td><strong>Email:</strong> <?php echo e($user->email); ?></td>
                    <td><strong>Currency:</strong> <?php echo e(currency($user->currency, 'code')); ?></td>
                </tr>
                <tr>
                    <td>
                        <strong>Period:</strong> <?php echo e(\Carbon\Carbon::parse($from)->format('M d, Y')); ?> -
                        <?php echo e(\Carbon\Carbon::parse($to)->format('M d, Y')); ?>

                    </td>

                    <td><strong>Date Generated:</strong> <?php echo e(now()->format('M d, Y h:i A')); ?></td>
                </tr>
            </table>
        </div>

        <!-- Title -->
        <div class="statement-title">Transaction Summary</div>

        <!-- Transactions Table -->
        <table class="transactions">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Date</th>
                    <th>Description</th>
                    <th>Type</th>
                    <th>Amount (<?php echo e(currency($user->currency, 'code')); ?>)</th>
                    <th>Balance (<?php echo e(currency($user->currency, 'code')); ?>)</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($index + 1); ?></td>
                        <td><?php echo e(formatDateTime($transaction->transaction_at)); ?></td>
                        <td><?php echo e($transaction->description ?? 'N/A'); ?></td>
                        <td><?php echo e($transaction->type->label()); ?></td>
                        <td class="<?php echo e($transaction->isDirectionCredit() ? 'credit' : 'debit'); ?>">
                            <?php echo e($transaction->isDirectionCredit() ? '+' : '-'); ?><?php echo e(formatAmount($transaction->amount)); ?>

                        </td>
                        <td><?php echo e(formatAmount($transaction->current_balance)); ?></td>
                        <td><?php echo e(ucfirst($transaction->status->label())); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <!-- Summary Section -->
        <table class="summary">
            <tr>
                <td><strong>Total Transactions:</strong></td>
                <td><?php echo e(count($transactions)); ?></td>
            </tr>
            <tr>
                <td><strong>Total Volume:</strong></td>
                <td><?php echo e(formatAmount($totalAmount)); ?> <?php echo e(currency($user->currency, 'code')); ?></td>
            </tr>
        </table>

        <!-- Footer -->
        <div class="footer">
            <?php echo e(config('app.name')); ?> | Confidential Statement | Generated on <?php echo e(now()->format('M d, Y h:i A')); ?>

        </div>

    </body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.0\resources\views/pdf/account_statement.blade.php ENDPATH**/ ?>